Imports System.Globalization

'
' Egzemplarze tej klasy zawieraj informacje o profilach pracownikw.
'
Public Class EmployeeProfile
    Private myId As EmployeeID ' Identyfikator pracownika
    Private myLocale As CultureInfo ' Preferowany jzyk menu
    Private mySupervisor As Boolean
    Private myName As String    ' Nazwisko pracownika

    '
    ' Konstruktor
    ' id  Identyfikator identyfikator pracownika.
    ' locale  Egzemplarz egzemplarz klasy CultureInfo reprezentujcy jzyk wybrany przez pracownika.
    ' supervisor  Ma ma warto true, jeli dany pracownik naley do kadry kierowniczej.
    ' name  Nazwisko nazwisko pracownika.
    Public Sub New(ByVal id As EmployeeID, ByVal locale As CultureInfo, ByVal supervisor As Boolean, ByVal name As String)
        Me.myId = id
        Me.myLocale = locale
        Me.mySupervisor = supervisor
        Me.myName = name
    End Sub 'New

    ' Zwraca identyfikator danego pracownika.
    Public ReadOnly Property ID() As EmployeeID
        Get
            Return myId
        End Get
    End Property

    ' Egzemplarz klasy CultureInfo reprezentujcy jzyk wybrany przez pracownika.
    Public ReadOnly Property Locale() As CultureInfo
        Get
            Return myLocale
        End Get
    End Property

    '
    ' Zwraca warto true, jeli dany pracownik naley do kadry kierowniczej.
    '
    Public Function IsSupervisor() As Boolean
        Return mySupervisor
    End Function

End Class 'EmployeeProfile
